require "prefabutil"

local assets=
{
	Asset("ANIM", "anim/freedom_exoskeleton.zip"),
	Asset("ANIM", "anim/freedom.zip"),
	Asset("IMAGE", "images/inventoryimages/freedom_exoskeleton.tex"),
	Asset("ATLAS", "images/inventoryimages/freedom_exoskeleton.xml"),
}

local prefabs =
{
	"freedom",
}



local function OnBlocked(owner) 
    owner.SoundEmitter:PlaySound("dontstarve/wilson/hit_armour")
end

local function hurtowner(inst, owner)
	if (owner.components.health) then
		owner.components.health:DoDelta(-1,-1)
end
end

local function nightvision(inst)
	if inst:HasTag("nightonlyvision") and (GetClock():IsNight() or GetWorld():IsCave() or GetClock():IsDusk()) then
		GetClock():SetNightVision(true)
		GetWorld().components.colourcubemanager:SetOverrideColourCube("images/colour_cubes/mole_vision_on_cc.tex", 2)
		else
		GetClock():SetNightVision(false)
		GetWorld().components.colourcubemanager:SetOverrideColourCube(nil, .5)
	end
end

local function removenightvision(inst)
		GetClock():SetNightVision(false)
		GetWorld().components.colourcubemanager:SetOverrideColourCube(nil, .5)
end

local function onequip(inst, owner) 
inst:AddTag("nightonlyvision")
    inst:ListenForEvent("blocked", OnBlocked, owner)
	owner:AddTag("antirad")

	if not owner:HasTag("stalker") then
	inst.components.equippable.walkspeedmult = .8
	else if owner:HasTag("stalker") and not owner:HasTag("freedom") then
	inst.components.equippable.walkspeedmult = 1.1
	end
	end
	if inst.task ~= nil then
        inst.task:Cancel()
        inst.task = nil
    end
end

local function onunequip(inst, owner) 
    inst:RemoveEventCallback("blocked", OnBlocked, owner)
	owner:RemoveTag("antirad")
	inst:DoTaskInTime(0, removenightvision, nil, owner)
	inst:RemoveTag("nightonlyvision")
	if owner:HasTag("rad") then
	inst.task = inst:DoPeriodicTask(4, hurtowner, nil, owner)
	end
end



local function fnab()
	local inst = CreateEntity()
    
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
        	
    inst.AnimState:SetBank("freedom_exoskeleton")
    inst.AnimState:SetBuild("freedom_exoskeleton")
    inst.AnimState:PlayAnimation("idle", false)
	
	MakeInventoryPhysics(inst)
	
	-- inst:AddComponent("stackable")
	-- inst.components.stackable.maxsize = 1

	inst:AddComponent("inspectable")
	
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.cangoincontainer = true
	inst.components.inventoryitem.foleysound = "dontstarve/movement/foley/marblearmour"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/freedom_exoskeleton.xml"
    
    inst:AddComponent("armor")
    	
	inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BODY
	inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
	inst.components.equippable.insulated = true
	inst.components.inventoryitem.keepondeath = true
	
	inst:DoPeriodicTask(3, nightvision, nil, inst)
	
	if IsDLCEnabled(REIGN_OF_GIANTS) then
	inst.components.armor:InitCondition(2500, 0.9)
	
	inst:AddComponent("insulator")
    inst.components.insulator:SetInsulation(TUNING.INSULATION_MED)
	
	inst:AddComponent("waterproofer")
	inst.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_MED)
	
	elseif IsDLCEnabled(0002) then
	inst.components.armor:InitCondition(2500, 0.9)
	
	inst:AddComponent("insulator")
    inst.components.insulator:SetInsulation(TUNING.INSULATION_MED)
	
	inst:AddComponent("waterproofer")
	inst.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_MED)
	
	inst.components.equippable.poisonblocker = true
	-- inst.components.equippable.poisongasblocker = true
	end

	
    return inst
end

STRINGS.RECIPE_DESC.FREEDOM_EXOSKELETON = "Repair your suit\ncompletely."

return Prefab( "common/inventory/freedom_exoskeleton", fnab, assets) 